/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.gui;

import java.awt.Desktop;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.VBox;
import org.apache.commons.collections4.CollectionUtils;
import org.dajlab.core.DaJLabRuntimeException;
import org.dajlab.gui.DajlabScene;
import org.dajlab.gui.MessagesUtil;
import org.dajlab.gui.extension.DajlabControllerExtensionInterface;
import org.dajlab.gui.extension.DajlabModelInterface;
import org.dajlab.gui.extension.MenuExtensionInterface;

public class DajlabMenuBar
extends MenuBar {
    public DajlabMenuBar(List<MenuExtensionInterface> extensions, DajlabScene scene, String appTitle) {
        Menu menuFile = new Menu(MessagesUtil.getString("dajlab.item_File"));
        MenuItem itemOpen = new MenuItem(MessagesUtil.getString("dajlab.item_Open"));
        itemOpen.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        itemOpen.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                try {
                    ((DajlabScene)DajlabMenuBar.this.getScene()).loadModel();
                }
                catch (DaJLabRuntimeException e) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setHeaderText(MessagesUtil.getString(e.getMessage()));
                    alert.showAndWait();
                }
            }
        });
        menuFile.getItems().add((Object)itemOpen);
        MenuItem itemSaveAs = new MenuItem(MessagesUtil.getString("dajlab.item_Saveas"));
        itemSaveAs.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        itemSaveAs.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                try {
                    ((DajlabScene)DajlabMenuBar.this.getScene()).saveModel();
                }
                catch (DaJLabRuntimeException e) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setHeaderText(MessagesUtil.getString(e.getMessage()));
                    alert.showAndWait();
                }
            }
        });
        menuFile.getItems().add((Object)itemSaveAs);
        if (CollectionUtils.isNotEmpty(extensions)) {
            for (MenuExtensionInterface menuExtensionInterface : extensions) {
                Collection<MenuItem> items = menuExtensionInterface.getFileItems();
                if (!CollectionUtils.isNotEmpty(items)) continue;
                menuFile.getItems().add((Object)new SeparatorMenuItem());
                menuFile.getItems().addAll(items);
            }
        }
        menuFile.getItems().add((Object)new SeparatorMenuItem());
        MenuItem itemQuit = new MenuItem(MessagesUtil.getString("dajlab.item_Exit"));
        itemQuit.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        itemQuit.setOnAction(e -> {
            e.consume();
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle(MessagesUtil.getString("dajlab.exit_confirm_title"));
            alert.setHeaderText(MessagesUtil.getString("dajlab.exit_confirm_text", appTitle));
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                for (DajlabControllerExtensionInterface<DajlabModelInterface> controller : scene.getControllers()) {
                    controller.disconnect();
                }
                Platform.exit();
            }
        });
        menuFile.getItems().add((Object)itemQuit);
        this.getMenus().add((Object)menuFile);
        if (CollectionUtils.isNotEmpty(extensions)) {
            for (MenuExtensionInterface extension : extensions) {
                Collection<Menu> menus = extension.getMenus();
                if (!CollectionUtils.isNotEmpty((Collection)menus)) continue;
                this.getMenus().addAll((Collection)menus);
            }
        }
        Menu menu = new Menu("?");
        boolean itemHelp = false;
        if (CollectionUtils.isNotEmpty(extensions)) {
            for (MenuExtensionInterface extension : extensions) {
                Collection<MenuItem> items = extension.getAboutItems();
                if (!CollectionUtils.isNotEmpty(items)) continue;
                menu.getItems().addAll(items);
                itemHelp = itemHelp || items.size() > 0;
            }
        }
        if (itemHelp) {
            menu.getItems().add((Object)new SeparatorMenuItem());
        }
        MenuItem itemAbout = new MenuItem(MessagesUtil.getString("dajlab.item_About_dajlab"));
        itemAbout.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle(MessagesUtil.getString("dajlab.about_dajlab_title"));
                alert.setHeaderText(null);
                Label text = new Label(MessagesUtil.getString("dajlab.about_dajlab_text"));
                Hyperlink link = new Hyperlink();
                link.setText("https://www.dajlab.org");
                link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        try {
                            Desktop.getDesktop().browse(new URI("https://www.dajlab.org"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                VBox box = new VBox();
                box.getChildren().add((Object)text);
                box.getChildren().add((Object)link);
                alert.getDialogPane().contentProperty().set((Object)box);
                alert.setGraphic((Node)new ImageView(new Image("pictures/dajlab_100.png")));
                alert.showAndWait();
            }
        });
        menu.getItems().add((Object)itemAbout);
        this.getMenus().add((Object)menu);
    }
}

