/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.gui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.core.DaJLabConstants;
import org.dajlab.core.ExceptionFactory;
import org.dajlab.gui.DajlabModel;
import org.dajlab.gui.extension.DajlabModelInterface;
import org.hildan.fxgson.FxGson;

public final class ModelManager {
    private static final Logger logger = LogManager.getLogger(ModelManager.class);

    public static void saveModel(final File file, final DajlabModel dajlabModel) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Gson fxGson = FxGson.fullBuilder().setPrettyPrinting().create();
                JsonElement el = fxGson.toJsonTree((Object)dajlabModel);
                try {
                    JsonWriter w = new JsonWriter((Writer)new FileWriter(file));
                    w.setIndent("\t");
                    fxGson.toJson(el, w);
                    w.close();
                }
                catch (Exception e) {
                    logger.error("Unable to export model to file [{}]", (Object)file.getName());
                    ExceptionFactory.throwDaJLabRuntimeException(DaJLabConstants.ERR_SAVE_MODEL);
                }
            }
        });
    }

    public static <T extends DajlabModelInterface> DajlabModel loadModel(File file) {
        Gson fxGson = FxGson.fullBuilder().create();
        DajlabModel model = new DajlabModel();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(file));
            jsonReader.beginObject();
            if (jsonReader.hasNext()) {
                jsonReader.nextName();
                JsonObject ob = jsonParser.parse(jsonReader).getAsJsonObject();
                Set set = ob.entrySet();
                for (Map.Entry entry : set) {
                    String className = (String)entry.getKey();
                    JsonElement el = (JsonElement)entry.getValue();
                    try {
                        DajlabModelInterface obj = (DajlabModelInterface)fxGson.fromJson(el, Class.forName(className));
                        model.put(obj);
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn("Unable to load model for [{}]", (Object)className);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error("Unable to load model from file [{}]", (Object)file.getName());
            ExceptionFactory.throwDaJLabRuntimeException(DaJLabConstants.ERR_LOAD_MODEL);
        }
        return model;
    }
}

