/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.adapters.properties;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javafx.beans.property.Property;
import org.hildan.fxgson.adapters.properties.NullPropertyException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyTypeAdapter<I, P extends Property<? extends I>>
extends TypeAdapter<P> {
    private final TypeAdapter<I> delegate;
    private final boolean throwOnNullProperty;

    PropertyTypeAdapter(TypeAdapter<I> innerValueTypeAdapter, boolean throwOnNullProperty) {
        this.delegate = innerValueTypeAdapter;
        this.throwOnNullProperty = throwOnNullProperty;
    }

    public void write(JsonWriter out, P property) throws IOException {
        if (property == null) {
            if (this.throwOnNullProperty) {
                throw new NullPropertyException();
            }
            out.nullValue();
            return;
        }
        this.delegate.write(out, property.getValue());
    }

    public P read(JsonReader in) throws IOException {
        return this.createProperty(this.delegate.read(in));
    }

    @NotNull
    protected abstract P createProperty(@Nullable I var1);
}

