/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.adapters.properties.primitives;

import com.google.gson.TypeAdapter;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleFloatProperty;
import org.hildan.fxgson.adapters.properties.primitives.PrimitivePropertyTypeAdapter;

public class FloatPropertyTypeAdapter
extends PrimitivePropertyTypeAdapter<Float, FloatProperty> {
    public FloatPropertyTypeAdapter(TypeAdapter<Float> delegate, boolean throwOnNullProperty, boolean crashOnNullValue) {
        super(delegate, throwOnNullProperty, crashOnNullValue);
    }

    @Override
    protected Float extractPrimitiveValue(FloatProperty property) {
        return Float.valueOf(property.get());
    }

    @Override
    protected FloatProperty createDefaultProperty() {
        return new SimpleFloatProperty();
    }

    @Override
    protected FloatProperty wrapNonNullPrimitiveValue(Float deserializedValue) {
        return new SimpleFloatProperty(deserializedValue.floatValue());
    }
}

