/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.gui;

import java.util.Optional;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.StringUtils;
import org.dajlab.gui.MessagesUtil;

public abstract class AbstractDajlabTab
extends Tab {
    private static final String DEFAULT_ICON = "/pictures/roundicon.png";

    public final void enableRenaming(String picturePath) {
        HBox hb = new HBox();
        ImageView iv = this.getIcon(picturePath);
        iv.setOnMouseClicked((EventHandler)new EventHandler<Event>(){

            public void handle(Event mouseEvent) {
                if (((MouseEvent)mouseEvent).getButton().equals((Object)MouseButton.PRIMARY) && ((MouseEvent)mouseEvent).getClickCount() == 2) {
                    TextInputDialog input = new TextInputDialog((String)AbstractDajlabTab.this.textProperty().get());
                    input.setTitle(MessagesUtil.getString("dajlab.change_tab_title"));
                    input.setContentText(null);
                    input.setHeaderText(MessagesUtil.getString("dajlab.change_tab_text"));
                    input.setGraphic(null);
                    Optional ret = input.showAndWait();
                    if (ret.isPresent() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(CharSequence)ret.get()})) {
                        AbstractDajlabTab.this.updateTitle((String)ret.get());
                    }
                }
            }
        });
        hb.getChildren().add((Object)iv);
        this.setGraphic((Node)hb);
    }

    protected ImageView getIcon(String picturePath) {
        ImageView iv = null;
        iv = picturePath == null ? new ImageView(new Image(DEFAULT_ICON)) : new ImageView(new Image(picturePath));
        iv.setPreserveRatio(true);
        iv.setFitHeight(20.0);
        return iv;
    }

    public abstract void updateTitle(String var1);
}

