/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.gui;

import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.prefs.Preferences;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.FileChooser;
import org.dajlab.core.DaJLabRuntimeException;
import org.dajlab.gui.DajlabModel;
import org.dajlab.gui.ModelManager;
import org.dajlab.gui.extension.DajlabControllerExtensionInterface;
import org.dajlab.gui.extension.DajlabModelInterface;

public final class DajlabScene
extends Scene {
    private static final String PREVIOUS_FILE_PATH = "filePath";
    private List<DajlabControllerExtensionInterface<DajlabModelInterface>> controllers;

    public DajlabScene(Parent root, double width, double height) {
        super(root, width, height);
    }

    public final List<DajlabControllerExtensionInterface<DajlabModelInterface>> getControllers() {
        return this.controllers;
    }

    public final void setControllers(List<DajlabControllerExtensionInterface<DajlabModelInterface>> controllers) {
        this.controllers = controllers;
    }

    public final void loadModel() {
        DajlabModel model;
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open configuration file");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("daJLab json files", new String[]{"*.json"})});
        Preferences prefs = Preferences.userNodeForPackage(DajlabModel.class);
        String filePath = prefs.get(PREVIOUS_FILE_PATH, null);
        if (filePath != null) {
            fileChooser.setInitialDirectory(new File(filePath));
        }
        if ((file = fileChooser.showOpenDialog(this.getWindow())) != null && (model = ModelManager.loadModel(file)) != null) {
            for (DajlabControllerExtensionInterface<DajlabModelInterface> controller : this.controllers) {
                Type[] types;
                String typeNameController = null;
                for (Type type : types = controller.getClass().getGenericInterfaces()) {
                    if (!(type instanceof ParameterizedType) || !type.getTypeName().contains(DajlabControllerExtensionInterface.class.getSimpleName())) continue;
                    Type[] itypes = ((ParameterizedType)type).getActualTypeArguments();
                    typeNameController = itypes[0].getTypeName();
                    break;
                }
                if (typeNameController == null) continue;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(typeNameController);
                    controller.updateModel((DajlabModelInterface)model.get(clazz));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (DaJLabRuntimeException daJLabRuntimeException) {}
            }
        }
    }

    public final void saveModel() {
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save configuration file");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("daJLab json files", new String[]{"*.json"})});
        Preferences prefs = Preferences.userNodeForPackage(DajlabModel.class);
        String filePath = prefs.get(PREVIOUS_FILE_PATH, null);
        if (filePath != null) {
            fileChooser.setInitialDirectory(new File(filePath));
        }
        if ((file = fileChooser.showSaveDialog(this.getWindow())) != null) {
            prefs.put(PREVIOUS_FILE_PATH, file.getParentFile().getPath());
            ModelManager.saveModel(file, this.getModel());
        }
    }

    private DajlabModel getModel() {
        DajlabModel model = new DajlabModel();
        for (DajlabControllerExtensionInterface<DajlabModelInterface> controller : this.controllers) {
            DajlabModelInterface subModel = controller.getModel();
            model.put(subModel);
        }
        return model;
    }
}

