/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.gui;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.gui.extension.DajlabControllerExtensionInterface;
import org.dajlab.gui.extension.DajlabModelInterface;

public final class MessagesUtil {
    private static final String MESSAGES_PATH = "messages/";
    private static final String MESSAGES_EXT = "_messages";
    private static MessagesUtil messages = null;
    private Map<String, ResourceBundle> resources = new HashMap<String, ResourceBundle>();
    private static final Logger logger = LogManager.getLogger(MessagesUtil.class);

    private MessagesUtil() {
    }

    private static synchronized MessagesUtil getInstance() {
        if (messages == null) {
            messages = new MessagesUtil();
        }
        return messages;
    }

    public static void initializeMessages(List<DajlabControllerExtensionInterface<DajlabModelInterface>> controllers) {
        ResourceBundle resourceD = ResourceBundle.getBundle("messages/dajlab_messages");
        MessagesUtil.getInstance().resources.put("dajlab", resourceD);
        if (controllers != null) {
            for (DajlabControllerExtensionInterface<DajlabModelInterface> controller : controllers) {
                String resourceName = controller.getLocalization();
                if (resourceName == null) continue;
                String path = MESSAGES_PATH + resourceName + MESSAGES_EXT;
                try {
                    ResourceBundle resource = ResourceBundle.getBundle(path);
                    MessagesUtil.getInstance().resources.put(resourceName, resource);
                }
                catch (MissingResourceException e) {
                    logger.error("Unable to find the resource file [{}]", (Object)(path + ".properties"));
                }
            }
        }
    }

    public static String getString(String key) {
        String[] els;
        String ret = '!' + key + '!';
        if (key != null && (els = key.split("\\.", 2)).length == 2) {
            String resourceName = els[0];
            ResourceBundle resource = MessagesUtil.getInstance().resources.get(resourceName);
            if (resource != null) {
                try {
                    ret = resource.getString(els[1]);
                }
                catch (MissingResourceException e) {
                    logger.debug("No resource for the key [{}]", (Object)key);
                }
            } else {
                logger.debug("No resource for [{}]", (Object)resource);
            }
        }
        return ret;
    }

    public static String getString(String key, Object ... params) {
        String[] els;
        String ret = '!' + key + '!';
        if (key != null && (els = key.split("\\.", 2)).length == 2) {
            String resourceName = els[0];
            ResourceBundle resource = MessagesUtil.getInstance().resources.get(resourceName);
            if (resource != null) {
                try {
                    ret = MessageFormat.format(resource.getString(els[1]), params);
                }
                catch (MissingResourceException e) {
                    logger.debug("No resource for the key [{}]", (Object)key);
                }
            } else {
                logger.debug("No resource for [{}]", (Object)resource);
            }
        }
        return ret;
    }
}

