/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TabPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.apache.commons.collections4.CollectionUtils;
import org.dajlab.gui.AbstractDajlabTab;
import org.dajlab.gui.DajlabMenuBar;
import org.dajlab.gui.DajlabScene;
import org.dajlab.gui.MessagesUtil;
import org.dajlab.gui.extension.DajlabControllerExtensionInterface;
import org.dajlab.gui.extension.DajlabExtension;
import org.dajlab.gui.extension.DajlabModelInterface;
import org.dajlab.gui.extension.MenuExtensionInterface;
import org.dajlab.gui.extension.TabExtensionInterface;

public abstract class AbstractDajlabApplication
extends Application {
    private List<DajlabControllerExtensionInterface<DajlabModelInterface>> controllers = new ArrayList<DajlabControllerExtensionInterface<DajlabModelInterface>>();
    private List<TabExtensionInterface> tabPlugins = new ArrayList<TabExtensionInterface>();
    private List<MenuExtensionInterface> menuPlugins = new ArrayList<MenuExtensionInterface>();
    private String appTitle = null;

    public final void start(Stage stage) throws Exception {
        Application.Parameters params = this.getParameters();
        List paramsList = params.getRaw();
        VBox box = new VBox();
        DajlabScene scene = new DajlabScene((Parent)box, 1024.0, 600.0);
        scene.setControllers(this.controllers);
        MessagesUtil.initializeMessages(this.controllers);
        stage.setScene((Scene)scene);
        if (!paramsList.isEmpty()) {
            this.appTitle = (String)paramsList.get(0);
        }
        if (this.appTitle != null) {
            stage.setTitle(MessagesUtil.getString("dajlab.application_by", this.appTitle));
        } else {
            this.appTitle = "daJLab";
            stage.setTitle(MessagesUtil.getString("dajlab.default_title"));
        }
        TabPane tabPan = new TabPane();
        for (DajlabControllerExtensionInterface<DajlabModelInterface> controller : this.controllers) {
            controller.connect();
        }
        for (TabExtensionInterface tabPlugin : this.tabPlugins) {
            Collection<AbstractDajlabTab> tabs = tabPlugin.getTabs();
            if (!CollectionUtils.isNotEmpty(tabs)) continue;
            tabPan.getTabs().addAll(tabs);
        }
        if (tabPan.getTabs().size() > 0) {
            AbstractDajlabTab[] tabl = new AbstractDajlabTab[tabPan.getTabs().size()];
            tabPan.getTabs().toArray((Object[])tabl);
            AbstractDajlabTab defaultTab = this.selectDefaultTab(tabl);
            if (defaultTab == null) {
                tabPan.getSelectionModel().select(0);
            } else {
                tabPan.getSelectionModel().select((Object)defaultTab);
            }
        }
        stage.setOnCloseRequest(e -> {
            e.consume();
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle(MessagesUtil.getString("dajlab.exit_confirm_title"));
            alert.setHeaderText(MessagesUtil.getString("dajlab.exit_confirm_text", this.appTitle));
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                for (DajlabControllerExtensionInterface<DajlabModelInterface> controller : this.controllers) {
                    controller.disconnect();
                }
                Platform.exit();
            }
        });
        box.getChildren().add((Object)new DajlabMenuBar(this.menuPlugins, scene, this.appTitle));
        box.getChildren().add((Object)tabPan);
        stage.show();
    }

    public abstract AbstractDajlabTab selectDefaultTab(AbstractDajlabTab[] var1);

    public final void init() {
    }

    public void stop() {
    }

    public void registerPlugin(DajlabExtension plugin) {
        if (plugin != null) {
            if (plugin instanceof DajlabControllerExtensionInterface) {
                this.controllers.add((DajlabControllerExtensionInterface)plugin);
            }
            if (plugin instanceof TabExtensionInterface) {
                this.tabPlugins.add((TabExtensionInterface)plugin);
            }
            if (plugin instanceof MenuExtensionInterface) {
                this.menuPlugins.add((MenuExtensionInterface)plugin);
            }
        }
    }

    public static void startApplication(Class<? extends Application> appClass, String appTitle) {
        AbstractDajlabApplication.launch(appClass, (String[])new String[]{appTitle});
    }
}

