/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import org.dajlab.jcontrollab.core.AbstractPort;
import org.dajlab.jcontrollab.core.CLIProtocol;
import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.OutputInterface;
import org.dajlab.jcontrollab.core.OutputPortEnum;

public class Output
extends AbstractPort
implements OutputInterface {
    private OutputPortEnum port;

    protected Output(ControlLabInterface controllab, OutputPortEnum port) {
        this.setControlLab(controllab);
        this.port = port;
    }

    @Override
    public void forwardAndRun() {
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(this.port.getPort(), 24));
    }

    @Override
    public void backwardAndRun() {
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(this.port.getPort(), 16));
    }

    @Override
    public void reverseDirection() {
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(this.port.getPort(), 32));
    }

    @Override
    public void run() {
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(this.port.getPort(), 40));
    }

    @Override
    public void stop() {
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(this.port.getPort(), 48));
    }

    @Override
    public void backward() {
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(this.port.getPort(), 64));
    }

    @Override
    public void forward() {
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(this.port.getPort(), 72));
    }

    @Override
    public void setPower(int power) {
        int aPower = Math.abs(power) % 9;
        this.getControlLab().sendMessage(CLIProtocol.encodeModePower(this.port.getPort(), (short)aPower));
    }

    @Override
    public void runFor(int time) {
        this.getControlLab().sendMessage(CLIProtocol.encodeModeDuration(this.port.getPort(), time));
    }

    @Override
    public void setCyclicMode(int on, int off) {
        this.getControlLab().sendMessage(CLIProtocol.encodeCycle(this.port.getPort(), on, off));
    }

    @Override
    public void startCycle() {
        char[] tab = new char[]{this.port.getPort()};
        this.getControlLab().sendMessage(CLIProtocol.encodeMode(tab, 129));
    }

    public final OutputPortEnum getPort() {
        return this.port;
    }
}

