/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import org.dajlab.jcontrollab.core.OutputPortEnum;

public class CLIProtocol {
    protected static final short NOP = 2;
    protected static final int OUTPUT_SINGLE_ON_BACKWARD = 16;
    protected static final int OUTPUT_SINGLE_ON_FORWARD = 24;
    protected static final int OUTPUT_SINGLE_REVERSE_DIRECTION = 32;
    protected static final int OUTPUT_SINGLE_ON_CURRENT_DIRECTION = 40;
    protected static final int OUTPUT_SINGLE_OFF = 48;
    protected static final int OUTPUT_SINGLE_BACKWARD_DIRECTION = 64;
    protected static final int OUTPUT_SINGLE_FORWARD_DIRECTION = 72;
    protected static final byte CLOSE = 112;
    protected static final int OUTPUT_MULTIPLE_OFF_BREAK = 128;
    protected static final int OUTPUT_MULTIPLE_FLASHING = 129;
    protected static final int OUTPUT_MULTIPLE_OFF = 144;
    protected static final int OUTPUT_MULTIPLE_ON = 145;
    protected static final int OUTPUT_MULTIPLE_POWER0 = 146;
    protected static final int OUTPUT_MULTIPLE_FORWARD_DIRECTION = 147;
    protected static final int OUTPUT_MULTIPLE_BACKWARD_DIRECTION = 148;
    protected static final int OUTPUT_MULTIPLE_REVERSE_DIRECTION = 149;
    protected static final int OUTPUT_MULTIPLE_POWER = 176;
    protected static final int OUTPUT_MULTIPLE_ON_TIME = 192;
    protected static final int CYCLE_TIME_OFF = 224;
    protected static final int CYCLE_TIME_ON = 232;
    protected static final byte HELLO = 2;
    protected static final int DELAY = 2000;
    private static final char FIRST_OUTPUT_PORT = OutputPortEnum.A.getPort();
    private static final char LAST_OUTPUT_PORT = OutputPortEnum.H.getPort();
    protected static final String KNOCK_KNCOK = "p\u0000###Do you byte, when I knock?$$$";

    protected static byte encodeMode(char output, int mode) {
        return (byte)(mode + output - FIRST_OUTPUT_PORT);
    }

    protected static byte[] encodeModePower(char output, short power) {
        byte[] code = new byte[]{power > 0 ? (byte)(176 + power - 1) : (byte)-110, (byte)Math.pow(2.0, output - FIRST_OUTPUT_PORT)};
        return code;
    }

    protected static byte[] encodeModeDuration(char output, int time) {
        byte[] code = new byte[]{(byte)(192 + (output - FIRST_OUTPUT_PORT)), (byte)time};
        return code;
    }

    protected static byte[] encodeModeDuration(char[] outputs, int time) {
        byte[] code = new byte[2 * outputs.length];
        for (int i = 0; i < outputs.length; ++i) {
            code[i * 2] = (byte)(192 + (outputs[i] - FIRST_OUTPUT_PORT));
            code[i * 2 + 1] = (byte)time;
        }
        return code;
    }

    protected static byte[] encodeMode(char[] outputs, int mode) {
        byte[] code = new byte[2];
        int code2 = 0;
        for (int i = 0; i < outputs.length; ++i) {
            if (FIRST_OUTPUT_PORT > outputs[i] || outputs[i] > LAST_OUTPUT_PORT) continue;
            code2 += (int)Math.pow(2.0, outputs[i] - FIRST_OUTPUT_PORT);
        }
        code[0] = (byte)mode;
        code[1] = (byte)code2;
        return code;
    }

    protected static byte[] encodeModePower(char[] outputs, short power) {
        byte[] code = new byte[2];
        code[0] = power > 0 ? (int)(176 + power - 1) : -110;
        int code2 = 0;
        for (int i = 0; i < outputs.length; ++i) {
            if (FIRST_OUTPUT_PORT > outputs[i] || outputs[i] > LAST_OUTPUT_PORT) continue;
            code2 += (int)Math.pow(2.0, outputs[i] - FIRST_OUTPUT_PORT);
        }
        code[1] = (byte)code2;
        return code;
    }

    protected static byte[] encodeCycle(char output, int cycleOn, int cycleOff) {
        byte[] code = new byte[6];
        int code2 = 0;
        if (FIRST_OUTPUT_PORT <= output && output <= LAST_OUTPUT_PORT) {
            code2 += (int)Math.pow(2.0, output - FIRST_OUTPUT_PORT);
        }
        code[0] = (byte)(232 + (output - FIRST_OUTPUT_PORT));
        code[1] = (byte)cycleOn;
        code[2] = (byte)(224 + (output - FIRST_OUTPUT_PORT));
        code[3] = (byte)cycleOff;
        return code;
    }

    protected static byte[] encodeCycle(char[] outputs, int cycleOn, int cycleOff) {
        byte[] code = new byte[4 * outputs.length];
        for (int i = 0; i < outputs.length; ++i) {
            code[i * 4] = (byte)(232 + (outputs[i] - FIRST_OUTPUT_PORT));
            code[i * 4 + 1] = (byte)cycleOn;
            code[i * 4 + 2] = (byte)(224 + (outputs[i] - FIRST_OUTPUT_PORT));
            code[i * 4 + 3] = (byte)cycleOff;
        }
        return code;
    }
}

