/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import org.dajlab.jcontrollab.core.AbstractPort;
import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.InputInterface;
import org.dajlab.jcontrollab.core.InputPortEnum;
import org.dajlab.jcontrollab.core.SensorEvent;
import org.dajlab.jcontrollab.core.SensorListener;
import org.dajlab.jcontrollab.core.SensorTypeEnum;

public abstract class Input
extends AbstractPort
implements InputInterface {
    private InputPortEnum port;
    private final EventListenerList listeners = new EventListenerList();
    private short previousValue;
    private short value;
    private int status;

    protected Input(ControlLabInterface controllab, InputPortEnum port) {
        this.setControlLab(controllab);
        this.port = port;
    }

    protected void setValue(short aValue) {
        this.previousValue = this.value;
        this.value = aValue;
        this.fireValueChanged();
    }

    protected void setStatus(int aStatus) {
        this.status = aStatus;
    }

    private void fireValueChanged() {
        if (this.value != this.previousValue) {
            SensorEvent event = null;
            for (int i = 0; i < this.getSensorListeners().length; ++i) {
                SensorListener sl = (SensorListener)this.getSensorListeners()[i];
                if (event == null) {
                    event = new SensorEvent(this, this.getSensorType(), this.previousValue, this.value);
                }
                sl.valueChanged(event);
            }
        }
    }

    public final InputPortEnum getPort() {
        return this.port;
    }

    public void addSensorListener(SensorListener aListener) {
        this.listeners.add(SensorListener.class, aListener);
    }

    public void removeSensorListener(SensorListener aListener) {
        this.listeners.remove(SensorListener.class, aListener);
    }

    public EventListener[] getSensorListeners() {
        return this.listeners.getListeners(SensorListener.class);
    }

    public final short getValue() {
        return this.value;
    }

    public final int getStatus() {
        return this.status;
    }

    public abstract SensorTypeEnum getSensorType();
}

