/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.Input;
import org.dajlab.jcontrollab.core.InputPortEnum;
import org.dajlab.jcontrollab.core.SensorTypeEnum;

public class LightSensor
extends Input {
    private int initialLight = 0;
    private int tolerance = 0;

    public LightSensor(ControlLabInterface controllab, InputPortEnum port) {
        super(controllab, port);
    }

    @Override
    public SensorTypeEnum getSensorType() {
        return SensorTypeEnum.LIGHT_SENSOR;
    }

    public int getLight() {
        return this.getValue();
    }

    public void reset() {
        this.initialLight = this.getLight();
    }

    public boolean hasMoreLight() {
        return this.getLight() < this.initialLight - this.tolerance;
    }

    public boolean hasMoreLight(int aValue) {
        return this.getLight() < aValue - this.tolerance;
    }

    public boolean hasLessLight() {
        return this.getLight() > this.initialLight + this.tolerance;
    }

    public boolean hasLessLight(int aValue) {
        return this.getLight() > aValue + this.tolerance;
    }

    public int getInitialLight() {
        return this.initialLight;
    }

    public void setInitialLight(int initialLight) {
        this.initialLight = initialLight;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }
}

