/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.Input;
import org.dajlab.jcontrollab.core.InputPortEnum;
import org.dajlab.jcontrollab.core.RotationDirectionEnum;
import org.dajlab.jcontrollab.core.SensorTypeEnum;

public class RotationSensor
extends Input {
    private int angle = 0;

    public RotationSensor(ControlLabInterface controllab, InputPortEnum port) {
        super(controllab, port);
    }

    @Override
    public SensorTypeEnum getSensorType() {
        return SensorTypeEnum.LIGHT_SENSOR;
    }

    public int getAngle() {
        this.getValue();
        int turnAmount = this.getStatus() & 3;
        switch (turnAmount) {
            case 1: 
            case 2: 
            case 3: {
                if (this.getDirection() == RotationDirectionEnum.CLOCKWISE) {
                    this.angle = (this.angle + turnAmount) % 16;
                    break;
                }
                if (this.getDirection() != RotationDirectionEnum.COUNTERCW) break;
                this.angle = (16 + this.angle - turnAmount) % 16;
                break;
            }
        }
        return this.angle;
    }

    public void setAngle(int anAngle) {
        this.angle = anAngle % 16;
    }

    public void reset() {
        this.setAngle(0);
    }

    public RotationDirectionEnum getDirection() {
        return RotationDirectionEnum.fromValue(super.getStatus() & 4);
    }
}

