/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.core.CommandEvent;
import org.dajlab.core.CommandListener;
import org.dajlab.gui.AbstractDajlabTab;
import org.dajlab.gui.extension.DajlabControllerExtensionInterface;
import org.dajlab.gui.extension.TabExtensionInterface;
import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.ControlLabManager;
import org.dajlab.jcontrollab.core.OutputPortEnum;
import org.dajlab.jcontrollab.gui.SimpleRandomModule;
import org.dajlab.jcontrollab.gui.model.ConsoleModel;
import org.dajlab.jcontrollab.gui.model.JControlLabModel;
import org.dajlab.jcontrollab.gui.model.OutputModel;
import org.dajlab.jcontrollab.gui.view.CommandControlLabEvent;
import org.dajlab.jcontrollab.gui.view.ControlLabTab;

public class JControlLabController
implements DajlabControllerExtensionInterface<JControlLabModel>,
TabExtensionInterface,
CommandListener {
    private Map<String, ControlLabInterface> labControllers;
    private JControlLabModel mainModel = new JControlLabModel();
    private static Logger logger = LogManager.getLogger(JControlLabController.class);
    private List<AbstractDajlabTab> tabs;
    private Map<String, Map<OutputPortEnum, SimpleRandomModule>> modules;
    private static final String LABELS_PREFIX = "jcontrollab";
    private ControlLabManager manager;

    public List<AbstractDajlabTab> getTabs() {
        if (this.tabs == null && CollectionUtils.isNotEmpty(this.mainModel.getControlLabs().values())) {
            this.tabs = new ArrayList<AbstractDajlabTab>(this.mainModel.getControlLabs().size());
            for (ConsoleModel consoleModel : this.mainModel.getControlLabs().values()) {
                ControlLabTab tab = new ControlLabTab(consoleModel, this);
                this.tabs.add(tab);
            }
        }
        return this.tabs;
    }

    @Override
    public void connect() {
        this.manager = new ControlLabManager();
        this.manager.connect();
        List<ControlLabInterface> controllabs = this.manager.getControlLabs();
        this.labControllers = new HashMap<String, ControlLabInterface>(controllabs.size());
        this.modules = new HashMap<String, Map<OutputPortEnum, SimpleRandomModule>>(1);
        int i = 0;
        for (ControlLabInterface controlLab : controllabs) {
            this.labControllers.put(controlLab.getPort(), controlLab);
            ConsoleModel model = new ConsoleModel(i, "ControlLab " + i, controlLab.getPort());
            this.mainModel.getControlLabs().put(Integer.toString(i), model);
            this.modules.put(Integer.toString(i), new TreeMap());
            Map<OutputPortEnum, SimpleRandomModule> controllerModules = this.modules.get(Integer.toString(i));
            for (OutputPortEnum outputPort : model.getOutputModelsMap().keySet()) {
                OutputModel outputModel = model.getOutputModelsMap().get((Object)outputPort);
                SimpleRandomModule module = new SimpleRandomModule(controlLab, outputModel);
                controllerModules.put(outputPort, module);
            }
            ++i;
        }
    }

    @Override
    public void disconnect() {
        for (Map<OutputPortEnum, SimpleRandomModule> mapModules : this.modules.values()) {
            for (SimpleRandomModule module : mapModules.values()) {
                module.stop();
            }
        }
        for (ControlLabInterface controller : this.labControllers.values()) {
            controller.disconnect();
        }
    }

    @Override
    public void updateModel(JControlLabModel model) {
        if (model != null) {
            Set<String> connectedLabPorts = this.labControllers.keySet();
            HashSet<String> loadedLabPorts = new HashSet<String>();
            for (ConsoleModel clm : model.getControlLabs().values()) {
                loadedLabPorts.add(clm.getPort());
            }
            if (CollectionUtils.isEqualCollection(connectedLabPorts, loadedLabPorts)) {
                for (String idClm : model.getControlLabs().keySet()) {
                    ConsoleModel modelToUpdate = this.mainModel.getControlLabs().get(idClm);
                    ConsoleModel newModel = model.getControlLabs().get(idClm);
                    this.updateConsoleModel(modelToUpdate, newModel);
                }
            }
        }
    }

    private void updateConsoleModel(ConsoleModel modelToUpdate, ConsoleModel newModel) {
        modelToUpdate.setTitle(newModel.getTitle());
        for (OutputPortEnum port : OutputPortEnum.values()) {
            OutputModel ouputModel = modelToUpdate.getOutputModelsMap().get((Object)port);
            OutputModel newOuputModel = newModel.getOutputModelsMap().get((Object)port);
            ouputModel.setLabel(newOuputModel.getLabel());
            ouputModel.setOnOff(newOuputModel.isOnOff());
            ouputModel.setPower(newOuputModel.getPower());
            ouputModel.setReverse(newOuputModel.isReverse());
            ouputModel.setStartOn(newOuputModel.getStartOn());
            ouputModel.setStartOff(newOuputModel.getStartOff());
            ouputModel.setStopOn(newOuputModel.getStopOn());
            ouputModel.setStopOff(newOuputModel.getStopOff());
        }
    }

    @Override
    public JControlLabModel getModel() {
        return this.mainModel;
    }

    @Override
    public void newCommand(CommandEvent ev) {
        if (ev instanceof CommandControlLabEvent) {
            CommandControlLabEvent event = (CommandControlLabEvent)ev;
            OutputModel outputModel = event.getModel();
            String consoleNumber = Integer.toString(outputModel.getConsoleNumber());
            SimpleRandomModule module = this.modules.get(consoleNumber).get((Object)outputModel.getPort());
            switch (event.getCommand()) {
                case ONOFF: {
                    if (outputModel.isOnOff()) {
                        module.startMotor();
                        break;
                    }
                    module.stop();
                    break;
                }
                case POWER: {
                    module.setPower(outputModel.getPower());
                    break;
                }
                case REV: {
                    module.reverse();
                    break;
                }
                case STARTON: 
                case STOPON: 
                case STARTOFF: 
                case STOPOFF: {
                    module.updateRange();
                    break;
                }
            }
        }
    }

    @Override
    public String getLocalization() {
        return LABELS_PREFIX;
    }

    public final Map<String, ControlLabInterface> getLabControllers() {
        return this.labControllers;
    }
}

