/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.gui;

import org.dajlab.core.DaJLabModule;
import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.Output;
import org.dajlab.jcontrollab.gui.model.OutputModel;

public class SimpleRandomModule
extends DaJLabModule {
    private OutputModel outputModel;
    private Output output;
    private Thread thread;

    public SimpleRandomModule(ControlLabInterface controlLab, OutputModel outputModel) {
        this.outputModel = outputModel;
        this.output = controlLab.getOuput(outputModel.getPort());
        this.output.setPower(outputModel.getPower());
        if (!outputModel.isReverse()) {
            this.output.forward();
        } else {
            this.output.backward();
        }
        if (outputModel.isOnOff()) {
            this.thread = this.launch();
        }
    }

    @Override
    public void codeThread() {
        int timeOn = this.calculateTime(this.outputModel.getStartOn(), this.outputModel.getStopOn());
        System.out.println("temps de marche calcule = " + timeOn);
        this.output.run();
        try {
            Thread.sleep(timeOn);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        int timeOff = this.calculateTime(this.outputModel.getStartOff(), this.outputModel.getStopOff());
        System.out.println("temps d'arret calcule = " + timeOff);
        if (timeOff > 0) {
            this.output.stop();
            try {
                Thread.sleep(timeOff);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private int calculateTime(int lowValue, int highValue) {
        if (lowValue == highValue) {
            return lowValue;
        }
        int time = 0;
        int rand = (int)(Math.random() * 1000.0);
        System.out.println("rand = " + rand);
        time = lowValue + rand % (highValue - lowValue);
        return time * 1000;
    }

    @Override
    public void onLaunch() {
    }

    @Override
    public void onStop() {
        this.output.stop();
        if (this.isRunning()) {
            this.thread.interrupt();
        }
    }

    public void startMotor() {
        this.thread = this.launch();
    }

    public void setPower(int power) {
        this.output.setPower(power);
    }

    public void reverse() {
        this.output.reverseDirection();
    }

    public void updateRange() {
    }
}

