/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.gui.view;

import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.RangeSlider;
import org.dajlab.core.CommandListener;
import org.dajlab.gui.MessagesUtil;
import org.dajlab.jcontrollab.gui.model.ControlLabCommandEnum;
import org.dajlab.jcontrollab.gui.model.OutputModel;
import org.dajlab.jcontrollab.gui.view.CommandControlLabEvent;

public class OutputPane
extends GridPane {
    private static final Logger logger = LogManager.getLogger(OutputPane.class);
    private EventListenerList commandListeners = new EventListenerList();
    private boolean editLabel = false;
    private boolean overLabel = false;
    private String previousLabel = "";

    public OutputPane(final OutputModel model) {
        this.setHgap(10.0);
        this.setVgap(10.0);
        this.setPadding(new Insets(5.0));
        this.setAlignment(Pos.CENTER);
        final Text label = new Text();
        label.textProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{model.labelProperty(), " (", model.getPort().getLabel(), ")"}));
        final TextField textField = new TextField();
        textField.setVisible(false);
        textField.setPrefWidth(150.0);
        textField.textProperty().bindBidirectional((Property)model.labelProperty());
        label.setOnMouseEntered(e -> {
            if (!this.editLabel && !this.overLabel) {
                this.overLabel = true;
                label.setVisible(false);
                textField.setVisible(true);
                this.previousLabel = textField.getText();
            }
            e.consume();
        });
        textField.setOnMouseExited(e -> {
            if (!this.editLabel && this.overLabel) {
                label.setVisible(true);
                textField.setVisible(false);
            }
            this.overLabel = false;
            e.consume();
        });
        textField.setOnMouseEntered(e -> {
            this.overLabel = true;
        });
        textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (newPropertyValue.booleanValue()) {
                    OutputPane.this.editLabel = true;
                } else {
                    OutputPane.this.editLabel = false;
                    OutputPane.this.previousLabel = textField.getText();
                    label.setVisible(true);
                    textField.setVisible(false);
                }
            }
        });
        textField.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.editLabel = false;
                textField.setText(this.previousLabel);
                label.setVisible(true);
                textField.setVisible(false);
            }
        });
        textField.setOnAction(e -> {
            label.setVisible(true);
            textField.setVisible(false);
            this.previousLabel = textField.getText();
            e.consume();
            this.editLabel = false;
        });
        this.add((Node)label, 0, 0, 1, 1);
        this.add((Node)textField, 0, 0, 1, 1);
        CheckBox onOff = new CheckBox();
        onOff.selectedProperty().bindBidirectional((Property)model.onOffProperty());
        model.onOffProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                logger.debug("Event [ON/OFF] for ControlLab [{}] [{}] : [{}]", (Object)model.getConsoleNumber(), (Object)model.getLabel(), (Object)newValue);
                OutputPane.this.fireEvent(model, ControlLabCommandEnum.ONOFF);
            }
        });
        this.add((Node)onOff, 1, 0, 1, 1);
        Slider power = new Slider();
        power.setMin(0.0);
        power.setMax(8.0);
        power.setValue(5.0);
        power.setShowTickLabels(true);
        power.setShowTickMarks(true);
        power.setMajorTickUnit(1.0);
        power.setMinorTickCount(0);
        power.setBlockIncrement(1.0);
        power.setSnapToTicks(true);
        power.valueProperty().bindBidirectional((Property)model.powerProperty());
        power.setPrefWidth(200.0);
        model.powerProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [POWER] for ControlLab [{}] [{}] : [{}]", (Object)model.getConsoleNumber(), (Object)model.getLabel(), (Object)newValue);
                OutputPane.this.fireEvent(model, ControlLabCommandEnum.POWER);
            }
        });
        this.add((Node)power, 2, 0, 1, 2);
        CheckBox rev = new CheckBox();
        rev.selectedProperty().bindBidirectional((Property)model.reverseProperty());
        model.reverseProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                logger.debug("Event [REV.] for ControlLab [{}] [{}] : [{}]", (Object)model.getConsoleNumber(), (Object)model.getLabel(), (Object)newValue);
                OutputPane.this.fireEvent(model, ControlLabCommandEnum.REV);
            }
        });
        this.add((Node)rev, 3, 0, 1, 1);
        RangeSlider onSlider = new RangeSlider(0.0, 600.0, 60.0, 60.0);
        onSlider.setBlockIncrement(60.0);
        onSlider.setPrefWidth(240.0);
        onSlider.lowValueProperty().bindBidirectional((Property)model.startOnProperty());
        model.startOnProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [START ON] for ControlLab [{}] [{}] : [{}]", (Object)model.getConsoleNumber(), (Object)model.getLabel(), (Object)newValue);
                OutputPane.this.fireEvent(model, ControlLabCommandEnum.STARTON);
            }
        });
        onSlider.highValueProperty().bindBidirectional((Property)model.stopOnProperty());
        model.stopOnProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [STOP ON] for ControlLab [{}] [{}] : [{}]", (Object)model.getConsoleNumber(), (Object)model.getLabel(), (Object)newValue);
                OutputPane.this.fireEvent(model, ControlLabCommandEnum.STOPON);
            }
        });
        this.add((Node)onSlider, 4, 0, 1, 1);
        Label textOn = new Label();
        textOn.textProperty().bind((ObservableValue)Bindings.format((String)MessagesUtil.getString("jcontrollab.betweenRange"), (Object[])new Object[]{onSlider.lowValueProperty(), onSlider.highValueProperty()}));
        this.add((Node)textOn, 4, 1, 1, 1);
        RangeSlider offSlider = new RangeSlider(0.0, 600.0, 60.0, 60.0);
        offSlider.setBlockIncrement(60.0);
        offSlider.setPrefWidth(240.0);
        offSlider.lowValueProperty().bindBidirectional((Property)model.startOffProperty());
        model.startOffProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [START OFF] for ControlLab [{}] [{}] : [{}]", (Object)model.getConsoleNumber(), (Object)model.getLabel(), (Object)newValue);
                OutputPane.this.fireEvent(model, ControlLabCommandEnum.STARTOFF);
            }
        });
        offSlider.highValueProperty().bindBidirectional((Property)model.stopOffProperty());
        model.stopOffProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [STOP OFF] for ControlLab [{}] [{}] : [{}]", (Object)model.getConsoleNumber(), (Object)model.getLabel(), (Object)newValue);
                OutputPane.this.fireEvent(model, ControlLabCommandEnum.STOPOFF);
            }
        });
        this.add((Node)offSlider, 5, 0, 1, 1);
        Label textOff = new Label();
        textOff.textProperty().bind((ObservableValue)Bindings.format((String)MessagesUtil.getString("jcontrollab.betweenRange"), (Object[])new Object[]{offSlider.lowValueProperty(), offSlider.highValueProperty()}));
        this.add((Node)textOff, 5, 1, 1, 1);
    }

    public void addCommandListeners(CommandListener listener) {
        this.commandListeners.add(CommandListener.class, listener);
    }

    private void fireEvent(OutputModel model, ControlLabCommandEnum cmd) {
        if (this.commandListeners != null) {
            CommandControlLabEvent event = new CommandControlLabEvent(model, cmd);
            for (CommandListener listener : (CommandListener[])this.commandListeners.getListeners(CommandListener.class)) {
                listener.newCommand(event);
            }
        }
    }
}

