/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.core;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.jtoypad.core.Tag;

public class TagDecoder {
    private static Logger logger = LogManager.getLogger(TagDecoder.class);
    private static ResourceBundle characters = PropertyResourceBundle.getBundle("characters");
    private static ResourceBundle vehicles = PropertyResourceBundle.getBundle("vehicles");
    private static byte[] teakey = new byte[]{85, -2, -10, -80, 98, -65, 11, 65, -55, -77, 124, -76, -105, 62, 41, 123};

    private static int[] encipher(int v0, int v1) {
        int y = v0;
        int z = v1;
        int sum = 0;
        int delta = -1640531527;
        int a = TagDecoder.readUInt32LE(teakey, 0);
        int b = TagDecoder.readUInt32LE(teakey, 4);
        int c = TagDecoder.readUInt32LE(teakey, 8);
        int d = TagDecoder.readUInt32LE(teakey, 12);
        int n = 32;
        while (n-- > 0) {
            z += ((y += (z << 4) + a ^ z + (sum -= 1640531527) ^ (z >>> 5) + b) << 4) + c ^ y + sum ^ (y >>> 5) + d;
        }
        return new int[]{y, z};
    }

    private static int[] decipher(int v0, int v1) {
        int y = v0;
        int z = v1;
        int sum = -957401312;
        int delta = -1640531527;
        int a = TagDecoder.readUInt32LE(teakey, 0);
        int b = TagDecoder.readUInt32LE(teakey, 4);
        int c = TagDecoder.readUInt32LE(teakey, 8);
        int d = TagDecoder.readUInt32LE(teakey, 12);
        int n = 32;
        while (n-- > 0) {
            y -= ((z -= (y << 4) + c ^ y + sum ^ (y >>> 5) + d) << 4) + a ^ z + sum ^ (z >>> 5) + b;
            sum += 1640531527;
        }
        return new int[]{y, z};
    }

    public static byte[] encode(byte[] data) {
        byte[] data2;
        logger.trace("Encoding {}", (Object)TagDecoder.byteToHex(data));
        byte[] bp = data2 = ByteBuffer.allocate(8).putInt(TagDecoder.readUInt32LE(data, 0)).putInt(TagDecoder.readUInt32LE(data, 4)).array();
        int r0 = bp[0] << 24 | (bp[1] & 0xFF) << 16 | (bp[2] & 0xFF) << 8 | bp[3] & 0xFF;
        int r1 = bp[4] << 24 | (bp[5] & 0xFF) << 16 | (bp[6] & 0xFF) << 8 | bp[7] & 0xFF;
        int[] r = TagDecoder.encipher(r0, r1);
        ByteBuffer bff = ByteBuffer.allocate(8);
        TagDecoder.writeUInt32LE(r[0], bff);
        TagDecoder.writeUInt32LE(r[1], bff);
        return bff.array();
    }

    private static byte[] decodeData(byte[] data) {
        int d1 = TagDecoder.readUInt32LE(data, 0);
        int d2 = TagDecoder.readUInt32LE(data, 4);
        int[] tmp = TagDecoder.decipher(d1, d2);
        ByteBuffer bff = ByteBuffer.allocate(8);
        TagDecoder.writeUInt32LE(tmp[0], bff);
        TagDecoder.writeUInt32LE(tmp[1], bff);
        return bff.array();
    }

    public static Tag decodeCharacter(byte[] data) {
        logger.trace("Decoding character {}", (Object)TagDecoder.byteToHex(data));
        Tag tag = new Tag();
        byte[] dataDecod = TagDecoder.decodeData(data);
        int id = TagDecoder.readUInt32LE(dataDecod, 0);
        tag.setId(id);
        logger.debug("Character's id = [{}]", (Object)id);
        String name = null;
        try {
            name = characters.getString(String.valueOf(id));
            logger.debug("Character's name = [{}]", (Object)name);
        }
        catch (MissingResourceException e) {
            logger.debug("No character for id [{}]", (Object)id);
        }
        tag.setName(name);
        return tag;
    }

    public static Tag decodeVehicle(byte[] data) {
        logger.trace("Decoding vehicle {}", (Object)TagDecoder.byteToHex(data));
        Tag tag = new Tag();
        int id = TagDecoder.readUInt16LE(data, 0);
        tag.setId(id);
        logger.debug("Vehicle's id = [{}]", (Object)id);
        String name = null;
        try {
            name = vehicles.getString(String.valueOf(id));
            logger.debug("Vehicle's name = [{}]", (Object)name);
        }
        catch (MissingResourceException e) {
            logger.debug("No vehicle for id [{}]", (Object)id);
        }
        tag.setName(name);
        return tag;
    }

    private static int readUInt16LE(byte[] bytes, int pointer) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, pointer, 2);
        buffer.put(new byte[6]);
        buffer.flip();
        return buffer.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private static int readUInt32LE(byte[] bytes, int pointer) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, pointer, 4);
        buffer.put(new byte[4]);
        buffer.flip();
        return buffer.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private static void writeUInt32LE(int v, ByteBuffer buf) {
        buf.put((byte)(v & 0xFF));
        buf.put((byte)((v & 0xFF00) >> 8));
        buf.put((byte)((v & 0xFF0000) >> 16));
        buf.put((byte)((v & 0xFF000000) >> 24));
    }

    public static final String byteToHex(byte[] data) {
        StringBuilder mess = new StringBuilder();
        for (int i = 0; i < data.length - 1; ++i) {
            byte b = data[i];
            mess.append(String.format("%02X ", b));
        }
        mess.append(String.format("%02X", data[data.length - 1]));
        return mess.toString();
    }
}

