/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.core;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbEndpoint;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbPipe;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.jtoypad.core.ActionEnum;
import org.dajlab.jtoypad.core.Color;
import org.dajlab.jtoypad.core.CommandEnum;
import org.dajlab.jtoypad.core.FadeColor;
import org.dajlab.jtoypad.core.FlashColor;
import org.dajlab.jtoypad.core.JToypadConstants;
import org.dajlab.jtoypad.core.PadEnum;
import org.dajlab.jtoypad.core.Tag;
import org.dajlab.jtoypad.core.TagDecoder;
import org.dajlab.jtoypad.core.TagEvent;
import org.dajlab.jtoypad.core.TagListener;
import org.dajlab.jtoypad.core.ToyPad;
import org.dajlab.jtoypad.core.ToyPadException;

public class ToyPadImpl
implements ToyPad,
UsbPipeListener {
    private static final byte PREFIX_GENERIC = 85;
    private static final byte PREFIX_EVENT = 86;
    private static final byte[] TOYPAD_INIT = new byte[]{85, 15, CommandEnum.INIT.getCommandId(), 1, 40, 99, 41, 32, 76, 69, 71, 79, 32, 50, 48, 49, 52, -9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte ENDPOINT_OUT = 1;
    private static final byte ENDPOINT_IN = -127;
    private UsbDevice usbDevice;
    private UsbInterface iface;
    private Logger logger = LogManager.getLogger(ToyPadImpl.class);
    private int messageCounter = 2;
    private EventListenerList tagListeners;
    private Map<Integer, TagEvent> mapEvents = new HashMap<Integer, TagEvent>();
    private UsbPipe pipeIn;
    private Map<String, Tag> tagCache;

    public ToyPadImpl(UsbDevice usbDevice) throws ToyPadException {
        this.usbDevice = usbDevice;
        this.tagCache = new HashMap<String, Tag>();
        UsbConfiguration configuration = usbDevice.getActiveUsbConfiguration();
        this.iface = (UsbInterface)configuration.getUsbInterfaces().get(0);
        this.open();
        this.sendMessage(TOYPAD_INIT);
    }

    @Override
    public void open() throws ToyPadException {
        try {
            this.iface.claim(new UsbInterfacePolicy(){

                public boolean forceClaim(UsbInterface usbInterface) {
                    return true;
                }
            });
            UsbEndpoint endpoint = this.iface.getUsbEndpoint((byte)-127);
            this.pipeIn = endpoint.getUsbPipe();
            this.pipeIn.open();
            this.pipeIn.addUsbPipeListener((UsbPipeListener)this);
            byte[] data = new byte[32];
            this.pipeIn.asyncSubmit(data);
        }
        catch (Exception ex) {
            try {
                this.iface.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.error("Error while claiming usb [{}]", (Object)ex.getMessage());
            throw new ToyPadException(JToypadConstants.ERR_OPEN_USB);
        }
    }

    @Override
    public void close() throws ToyPadException {
        try {
            this.iface.release();
        }
        catch (Exception e) {
            this.logger.error("Error while release usb [{}]", (Object)e.getMessage());
            throw new ToyPadException(JToypadConstants.ERR_CLOSE_USB);
        }
    }

    private byte[] completeCommand(CommandEnum command, byte[] payload) {
        byte[] fullCommand = new byte[32];
        fullCommand[0] = 85;
        fullCommand[1] = command.getPayloadSize();
        fullCommand[2] = command.getCommandId();
        fullCommand[3] = (byte)this.messageCounter;
        for (int i = 0; i < payload.length; ++i) {
            fullCommand[i + 4] = payload[i];
        }
        fullCommand[i + 4] = this.calculateChecksum(fullCommand);
        ++this.messageCounter;
        return fullCommand;
    }

    private byte calculateChecksum(byte[] command) {
        byte checksum = 0;
        for (byte b : command) {
            checksum = (byte)(checksum + b);
            checksum = (byte)(checksum % 256);
        }
        return checksum;
    }

    private int sendCommand(CommandEnum command, byte[] payload) throws ToyPadException {
        this.logger.trace("Sending command [{}]", (Object)command.name());
        if (payload.length != command.getPayloadSize() - 2) {
            this.logger.error("Incorrect payload size : expected=[{}], actual=[{}]", (Object)command.getPayloadSize(), (Object)payload.length);
        }
        byte[] completedMessage = this.completeCommand(command, payload);
        this.sendMessage(completedMessage);
        return completedMessage[3];
    }

    private synchronized void sendMessage(byte[] command) throws ToyPadException {
        if (command.length != 32) {
            this.logger.error("Incorrect lenght. Expected 32 bits, got [{}]", (Object)command.length);
            throw new ToyPadException(JToypadConstants.ERR_MESSAGE_LENGTH);
        }
        byte[] message = command;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Sending {}", (Object)TagDecoder.byteToHex(message));
        }
        try {
            UsbEndpoint endpoint = this.iface.getUsbEndpoint((byte)1);
            UsbPipe pipe = endpoint.getUsbPipe();
            pipe.open();
            pipe.syncSubmit(message);
            pipe.close();
        }
        catch (Exception ex) {
            this.logger.error("Error while sending message to toypad.");
            throw new ToyPadException(JToypadConstants.ERR_USB_SEND);
        }
    }

    @Override
    public void turnOffPads() throws ToyPadException {
        this.switchPad(PadEnum.ALL, Color.BLACK);
    }

    @Override
    public void switchPad(PadEnum pad, Color color) throws ToyPadException {
        if (color != null) {
            this.sendCommand(CommandEnum.SWITCH_PAD, new byte[]{pad.getValue(), (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
        }
    }

    @Override
    public void switchPads(Color colorPadLeft, Color colorPadCenter, Color colorPadRight) throws ToyPadException {
        byte[] payload = new byte[12];
        if (colorPadCenter != null) {
            payload[0] = 1;
            payload[1] = (byte)colorPadCenter.getRed();
            payload[2] = (byte)colorPadCenter.getGreen();
            payload[3] = (byte)colorPadCenter.getBlue();
        }
        if (colorPadLeft != null) {
            payload[4] = 1;
            payload[5] = (byte)colorPadLeft.getRed();
            payload[6] = (byte)colorPadLeft.getGreen();
            payload[7] = (byte)colorPadLeft.getBlue();
        }
        if (colorPadRight != null) {
            payload[8] = 1;
            payload[9] = (byte)colorPadRight.getRed();
            payload[10] = (byte)colorPadRight.getGreen();
            payload[11] = (byte)colorPadRight.getBlue();
        }
        this.sendCommand(CommandEnum.SWITCH_PADS, payload);
    }

    @Override
    public void flashPad(PadEnum pad, FlashColor flashColor) throws ToyPadException {
        this.switchPad(pad, flashColor.getColor2());
        this.sendCommand(CommandEnum.FLASH_PAD, new byte[]{pad.getValue(), (byte)flashColor.getTimeForColor1(), (byte)flashColor.getTimeForColor2(), (byte)flashColor.getPulseCount(), (byte)flashColor.getColor1().getRed(), (byte)flashColor.getColor1().getGreen(), (byte)flashColor.getColor1().getBlue()});
    }

    @Override
    public void flashPads(FlashColor flashColorLeft, FlashColor flashColorCenter, FlashColor flashColorRight) throws ToyPadException {
        byte[] payload = new byte[21];
        Color color2Center = null;
        Color color2Left = null;
        Color color2Right = null;
        if (flashColorCenter != null) {
            payload[0] = 1;
            payload[1] = (byte)flashColorCenter.getTimeForColor1();
            payload[2] = (byte)flashColorCenter.getTimeForColor2();
            payload[3] = (byte)flashColorCenter.getPulseCount();
            payload[4] = (byte)flashColorCenter.getColor1().getRed();
            payload[5] = (byte)flashColorCenter.getColor1().getGreen();
            payload[6] = (byte)flashColorCenter.getColor1().getBlue();
            color2Center = flashColorCenter.getColor2();
        }
        if (flashColorLeft != null) {
            payload[7] = 1;
            payload[8] = (byte)flashColorLeft.getTimeForColor1();
            payload[9] = (byte)flashColorLeft.getTimeForColor2();
            payload[10] = (byte)flashColorLeft.getPulseCount();
            payload[11] = (byte)flashColorLeft.getColor1().getRed();
            payload[12] = (byte)flashColorLeft.getColor1().getGreen();
            payload[13] = (byte)flashColorLeft.getColor1().getBlue();
            color2Left = flashColorLeft.getColor2();
        }
        if (flashColorRight != null) {
            payload[14] = 1;
            payload[15] = (byte)flashColorRight.getTimeForColor1();
            payload[16] = (byte)flashColorRight.getTimeForColor2();
            payload[17] = (byte)flashColorRight.getPulseCount();
            payload[18] = (byte)flashColorRight.getColor1().getRed();
            payload[19] = (byte)flashColorRight.getColor1().getGreen();
            payload[20] = (byte)flashColorRight.getColor1().getBlue();
            color2Right = flashColorRight.getColor2();
        }
        this.switchPads(color2Left, color2Center, color2Right);
        this.sendCommand(CommandEnum.FLASH_PADS, payload);
    }

    @Override
    public void fadePadRandom(PadEnum pad, int pulseTime, int pulseCount) throws ToyPadException {
        this.sendCommand(CommandEnum.FADE_PAD_RANDOM, new byte[]{pad.getValue(), (byte)pulseTime, (byte)pulseCount});
    }

    @Override
    public void fadePad(PadEnum pad, FadeColor fadeColor) throws ToyPadException {
        this.switchPad(pad, fadeColor.getFromColor());
        this.sendCommand(CommandEnum.FADE_PAD, new byte[]{pad.getValue(), (byte)fadeColor.getPulseTime(), (byte)fadeColor.getPulseCount(), (byte)fadeColor.getToColor().getRed(), (byte)fadeColor.getToColor().getGreen(), (byte)fadeColor.getToColor().getBlue()});
    }

    @Override
    public void fadePad(PadEnum pad, Color fromColor, Color toColor, int time) throws ToyPadException {
        this.fadePad(pad, new FadeColor(fromColor, toColor, time, 1));
    }

    @Override
    public void fadePads(FadeColor fadeColorLeft, FadeColor fadeColorCenter, FadeColor fadeColorRight) throws ToyPadException {
        byte[] payload = new byte[18];
        Color fromColorCenter = null;
        Color fromColorLeft = null;
        Color fromColorRight = null;
        if (fadeColorCenter != null) {
            payload[0] = 1;
            payload[1] = (byte)fadeColorCenter.getPulseTime();
            payload[2] = (byte)fadeColorCenter.getPulseCount();
            payload[3] = (byte)fadeColorCenter.getToColor().getRed();
            payload[4] = (byte)fadeColorCenter.getToColor().getGreen();
            payload[5] = (byte)fadeColorCenter.getToColor().getBlue();
            fromColorCenter = fadeColorCenter.getFromColor();
        }
        if (fadeColorLeft != null) {
            payload[6] = 1;
            payload[7] = (byte)fadeColorLeft.getPulseTime();
            payload[8] = (byte)fadeColorLeft.getPulseCount();
            payload[9] = (byte)fadeColorLeft.getToColor().getRed();
            payload[10] = (byte)fadeColorLeft.getToColor().getGreen();
            payload[11] = (byte)fadeColorLeft.getToColor().getBlue();
            fromColorLeft = fadeColorLeft.getFromColor();
        }
        if (fadeColorRight != null) {
            payload[12] = 1;
            payload[13] = (byte)fadeColorRight.getPulseTime();
            payload[14] = (byte)fadeColorRight.getPulseCount();
            payload[15] = (byte)fadeColorRight.getToColor().getRed();
            payload[16] = (byte)fadeColorRight.getToColor().getGreen();
            payload[17] = (byte)fadeColorRight.getToColor().getBlue();
            fromColorRight = fadeColorRight.getFromColor();
        }
        this.switchPads(fromColorLeft, fromColorCenter, fromColorRight);
        this.sendCommand(CommandEnum.FADE_PADS, payload);
    }

    @Override
    public String getIdentifiant() {
        return this.usbDevice.toString();
    }

    private void decodeInput(byte[] data) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Incoming {}", (Object)TagDecoder.byteToHex(data));
        }
        Tag tag = null;
        if (data[0] == 86) {
            PadEnum pad = PadEnum.findPad(data[2]);
            ActionEnum action = ActionEnum.findAction(data[5]);
            if (pad != null && action != null) {
                TagEvent tagEvent = new TagEvent(this);
                tagEvent.setAction(action);
                tagEvent.setPad(pad);
                StringBuilder uid = new StringBuilder();
                for (int i = 6; i < 13; ++i) {
                    byte b = data[i];
                    uid.append(String.format("%02X", b));
                }
                String sUid = uid.toString();
                tagEvent.getTag().setUid(sUid);
                this.logger.debug("Tag's UID = [{}]", (Object)tagEvent.getTag().getUid());
                byte idx = data[4];
                tagEvent.setIndex(idx);
                if (action == ActionEnum.ADDED) {
                    this.logger.debug("Tag " + action.name().toLowerCase() + " to " + pad.name().toLowerCase() + " pad");
                    if (this.tagCache.containsKey(sUid)) {
                        tag = this.tagCache.get(sUid);
                        tagEvent.setTag(tag);
                        this.fireTagEvent(tagEvent);
                    } else {
                        try {
                            int counter = 0;
                            byte[] readPl = new byte[]{idx, 36};
                            counter = this.sendCommand(CommandEnum.READ, readPl);
                            this.mapEvents.put(new Integer(counter), tagEvent);
                        }
                        catch (ToyPadException e) {
                            this.logger.warn("Fail to send READ command.");
                        }
                    }
                } else {
                    this.logger.debug("Tag " + action.name().toLowerCase() + " from " + pad.name().toLowerCase() + " pad");
                    this.fireTagEvent(tagEvent);
                }
            }
        } else if (data[0] == 85) {
            if (data[1] == 18) {
                this.logger.debug("Response for READ command");
                int counter = data[2];
                byte isVehicle = data[13];
                if (isVehicle == 1) {
                    byte[] idVehicle = new byte[]{data[4], data[5]};
                    tag = TagDecoder.decodeVehicle(idVehicle);
                    TagEvent tagEvent = this.mapEvents.remove(new Integer(counter));
                    if (tagEvent != null) {
                        tag.setUid(tagEvent.getTag().getUid());
                        this.tagCache.put(tag.getUid(), tag);
                        tagEvent.getTag().setId(tag.getId());
                        tagEvent.getTag().setName(tag.getName());
                        this.fireTagEvent(tagEvent);
                    }
                } else {
                    byte[] lst_modelPl = new byte[8];
                    TagEvent tagEvent = this.mapEvents.remove(new Integer(counter));
                    if (tagEvent != null) {
                        lst_modelPl[0] = tagEvent.getIndex();
                        try {
                            counter = this.sendCommand(CommandEnum.LST_MODEL, TagDecoder.encode(lst_modelPl));
                            this.mapEvents.put(new Integer(counter), tagEvent);
                        }
                        catch (ToyPadException e) {
                            this.logger.warn("Fail to send LST_MODEL command.");
                        }
                    }
                }
            } else if (data[1] == 10) {
                this.logger.debug("Response for LST_MODEL command");
                byte counter = data[2];
                TagEvent tagEvent = this.mapEvents.remove(new Integer(counter));
                if (tagEvent != null) {
                    byte[] idcrypted = new byte[8];
                    for (int i = 4; i < 12; ++i) {
                        idcrypted[i - 4] = data[i];
                    }
                    tag = TagDecoder.decodeCharacter(idcrypted);
                    tag.setUid(tagEvent.getTag().getUid());
                    this.tagCache.put(tag.getUid(), tag);
                    tagEvent.getTag().setId(tag.getId());
                    tagEvent.getTag().setName(tag.getName());
                    this.fireTagEvent(tagEvent);
                }
            } else {
                this.logger.debug("Useless return.");
            }
        }
    }

    private void fireTagEvent(TagEvent tagEvent) {
        if (this.tagListeners != null) {
            for (TagListener listener : (TagListener[])this.tagListeners.getListeners(TagListener.class)) {
                listener.newTagEvent(tagEvent);
            }
        }
    }

    @Override
    public void addTagListener(TagListener tagListener) {
        if (this.tagListeners == null) {
            this.tagListeners = new EventListenerList();
        }
        this.tagListeners.add(TagListener.class, tagListener);
    }

    public void errorEventOccurred(UsbPipeErrorEvent event) {
        this.logger.error(event.getUsbException().getMessage());
    }

    public void dataEventOccurred(UsbPipeDataEvent event) {
        byte[] data = new byte[32];
        try {
            this.pipeIn.asyncSubmit(data);
        }
        catch (Exception e) {
            this.logger.error("Error while reading data. {}", (Object)e.getMessage());
        }
        if (event.getData() != null && event.getData().length == 32) {
            this.decodeInput(event.getData());
        }
    }
}

