/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.core;

import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.jtoypad.core.JToypadConstants;
import org.dajlab.jtoypad.core.ToyPad;
import org.dajlab.jtoypad.core.ToyPadException;
import org.dajlab.jtoypad.core.ToyPadImpl;

public class ToyPadManager {
    private static short VENDOR_ID = (short)3695;
    private static short PRODUCT_ID = (short)577;
    private List<ToyPad> toyPads;
    private Logger logger = LogManager.getLogger(ToyPadManager.class);

    public ToyPadManager() {
        this.toyPads = new ArrayList<ToyPad>();
    }

    public void connect() throws ToyPadException {
        List<UsbDevice> devices = this.findDevices(VENDOR_ID, PRODUCT_ID);
        if (devices != null) {
            for (UsbDevice usbDevice : devices) {
                try {
                    ToyPadImpl toyPad = new ToyPadImpl(usbDevice);
                    this.toyPads.add(toyPad);
                }
                catch (ToyPadException e) {
                    this.logger.error("Error while connecting to [{}]", (Object)usbDevice.toString());
                }
            }
        }
    }

    public void disconnect() {
        for (ToyPad toyPad : this.toyPads) {
            try {
                toyPad.close();
            }
            catch (ToyPadException e) {
                this.logger.error("Error while disconnecting [{}]", (Object)toyPad.getIdentifiant());
            }
        }
    }

    private List<UsbDevice> findDevices(short vendorId, short productId) throws ToyPadException {
        ArrayList<UsbDevice> list = new ArrayList(0);
        UsbHub hub = (UsbHub)this.getUsbRootHoob();
        if (hub != null) {
            list = this.findDevices(hub, vendorId, productId);
        }
        this.logger.debug("Number of toypads detected : [{}]", (Object)list.size());
        return list;
    }

    private List<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId) {
        ArrayList<UsbDevice> devices = new ArrayList<UsbDevice>();
        for (UsbDevice device : hub.getAttachedUsbDevices()) {
            List<UsbDevice> sousDevices;
            UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
            if (desc.idVendor() == vendorId && desc.idProduct() == productId) {
                devices.add(device);
            }
            if (!device.isUsbHub() || (sousDevices = this.findDevices((UsbHub)device, vendorId, productId)) == null) continue;
            devices.addAll(sousDevices);
        }
        return devices;
    }

    private UsbDevice getUsbRootHoob() throws ToyPadException {
        try {
            UsbServices services = UsbHostManager.getUsbServices();
            return services.getRootUsbHub();
        }
        catch (SecurityException | UsbException e) {
            this.logger.error("Error while accessing usb");
            throw new ToyPadException(JToypadConstants.ERR_OPEN_USB);
        }
    }

    public final List<ToyPad> getToyPads() {
        return this.toyPads;
    }
}

