/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.gui.model;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.dajlab.jtoypad.core.PadEnum;
import org.dajlab.jtoypad.gui.model.PadModel;

public class ToyPadModel {
    private IntegerProperty number = new SimpleIntegerProperty();
    private StringProperty title = new SimpleStringProperty();
    private StringProperty usbId = new SimpleStringProperty();
    private PadModel leftPadModel;
    private PadModel centerPadModel;
    private PadModel rightPadModel;
    private PadModel allPadModel;

    public ToyPadModel(int number, String title, String usbId) {
        this.number.set(number);
        this.title.set((Object)title);
        this.usbId.set((Object)usbId);
        this.leftPadModel = new PadModel(PadEnum.LEFT);
        this.leftPadModel.toyPadNumberProperty().bindBidirectional((Property)this.number);
        this.rightPadModel = new PadModel(PadEnum.RIGHT);
        this.rightPadModel.toyPadNumberProperty().bindBidirectional((Property)this.number);
        this.centerPadModel = new PadModel(PadEnum.CENTER);
        this.centerPadModel.toyPadNumberProperty().bindBidirectional((Property)this.number);
        this.allPadModel = new PadModel(PadEnum.ALL);
        this.allPadModel.toyPadNumberProperty().bindBidirectional((Property)this.number);
    }

    public PadModel getLeftPadModel() {
        return this.leftPadModel;
    }

    public void setLeftPadModel(PadModel leftPadModel) {
        this.leftPadModel = leftPadModel;
    }

    public PadModel getCenterPadModel() {
        return this.centerPadModel;
    }

    public void setCenterPadModel(PadModel centerPadModel) {
        this.centerPadModel = centerPadModel;
    }

    public PadModel getRightPadModel() {
        return this.rightPadModel;
    }

    public void setRightPadModel(PadModel rightPadModel) {
        this.rightPadModel = rightPadModel;
    }

    public PadModel getAllPadModel() {
        return this.allPadModel;
    }

    public void setAllPadModel(PadModel allPadModel) {
        this.allPadModel = allPadModel;
    }

    public PadModel getPadModel(PadEnum pad) {
        PadModel mod = null;
        switch (pad) {
            case LEFT: {
                mod = this.leftPadModel;
                break;
            }
            case CENTER: {
                mod = this.centerPadModel;
                break;
            }
            case RIGHT: {
                mod = this.rightPadModel;
                break;
            }
            case ALL: {
                mod = this.allPadModel;
                break;
            }
        }
        return mod;
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public final IntegerProperty numberProperty() {
        return this.number;
    }

    public final int getNumber() {
        return this.numberProperty().get();
    }

    public final void setNumber(int number) {
        this.numberProperty().set(number);
    }

    public final StringProperty usbIdProperty() {
        return this.usbId;
    }

    public final String getUsbId() {
        return (String)this.usbIdProperty().get();
    }

    public final void setUsbId(String usbId) {
        this.usbIdProperty().set((Object)usbId);
    }
}

