/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.gui.view;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.core.CommandListener;
import org.dajlab.gui.MessagesUtil;
import org.dajlab.jtoypad.core.Tag;
import org.dajlab.jtoypad.gui.model.CommandEnum;
import org.dajlab.jtoypad.gui.model.PadModel;
import org.dajlab.jtoypad.gui.view.CommandToyPadEvent;
import org.dajlab.jtoypad.gui.view.FadePane;
import org.dajlab.jtoypad.gui.view.FlashPane;
import org.dajlab.jtoypad.gui.view.OnPane;
import org.dajlab.jtoypad.gui.view.RandomFadePane;
import org.dajlab.jtoypad.gui.view.ToggleGroupValue;

public class PadPane
extends TitledPane {
    private static final Logger logger = LogManager.getLogger(PadPane.class);
    private EventListenerList commandListeners;

    public PadPane(PadModel padModel) {
        final PadModel model = padModel;
        this.commandListeners = new EventListenerList();
        this.setText(MessagesUtil.getString("jtoypad.pad." + model.getPad().toString().toLowerCase()));
        this.setCollapsible(false);
        VBox layout = new VBox();
        ToggleGroupValue radioGroup = new ToggleGroupValue();
        model.activeCommandProperty().bindBidirectional(radioGroup.valueProperty());
        model.activeCommandProperty().addListener((ChangeListener)new ChangeListener<CommandEnum>(){

            public void changed(ObservableValue<? extends CommandEnum> observable, CommandEnum oldValue, CommandEnum newValue) {
                logger.debug("Event [COMMAND] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue.name());
                CommandToyPadEvent event = new CommandToyPadEvent(model, null);
                PadPane.this.fireEvent(event);
            }
        });
        RadioButton offButton = new RadioButton(MessagesUtil.getString(CommandEnum.OFF.getMessage()));
        offButton.setUserData((Object)CommandEnum.OFF);
        offButton.setToggleGroup(radioGroup);
        offButton.setSelected(true);
        layout.getChildren().add((Object)offButton);
        RadioButton onButton = new RadioButton(MessagesUtil.getString(CommandEnum.ON.getMessage()));
        onButton.setUserData((Object)CommandEnum.ON);
        onButton.setToggleGroup(radioGroup);
        layout.getChildren().add((Object)onButton);
        layout.getChildren().add((Object)new OnPane(model));
        model.colorOnProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                logger.debug("Event [COLOR ON] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.ON);
                PadPane.this.fireEvent(event);
            }
        });
        RadioButton flashButton = new RadioButton(MessagesUtil.getString(CommandEnum.FLASH.getMessage()));
        flashButton.setUserData((Object)CommandEnum.FLASH);
        flashButton.setToggleGroup(radioGroup);
        layout.getChildren().add((Object)flashButton);
        FlashPane onPane = new FlashPane(model, true);
        model.colorFlashOnProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                logger.debug("Event [COLOR FLASH ON] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.FLASH);
                PadPane.this.fireEvent(event);
            }
        });
        model.timeFlashOnProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [TIME FLASH ON] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.FLASH);
                PadPane.this.fireEvent(event);
            }
        });
        layout.getChildren().add((Object)onPane);
        FlashPane offPane = new FlashPane(model, false);
        model.colorFlashOffProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                logger.debug("Event [COLOR FLASH OFF] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.FLASH);
                PadPane.this.fireEvent(event);
            }
        });
        model.timeFlashOffProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [TIME FLASH OFF] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.FLASH);
                PadPane.this.fireEvent(event);
            }
        });
        layout.getChildren().add((Object)offPane);
        RadioButton fadeButton = new RadioButton(MessagesUtil.getString(CommandEnum.FADE.getMessage()));
        fadeButton.setUserData((Object)CommandEnum.FADE);
        fadeButton.setToggleGroup(radioGroup);
        layout.getChildren().add((Object)fadeButton);
        layout.getChildren().add((Object)new FadePane(model));
        model.color1FadeProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                logger.debug("Event [COLOR FADE 1] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.FADE);
                PadPane.this.fireEvent(event);
            }
        });
        model.color2FadeProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                logger.debug("Event [COLOR FADE 2] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.FADE);
                PadPane.this.fireEvent(event);
            }
        });
        model.timeFadeProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [TIME FADE] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.FADE);
                PadPane.this.fireEvent(event);
            }
        });
        RadioButton fadeRandomButton = new RadioButton(MessagesUtil.getString(CommandEnum.RANDOM_FADE.getMessage()));
        fadeRandomButton.setUserData((Object)CommandEnum.RANDOM_FADE);
        fadeRandomButton.setToggleGroup(radioGroup);
        layout.getChildren().add((Object)fadeRandomButton);
        layout.getChildren().add((Object)new RandomFadePane(model));
        model.timeRandomFadeProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                logger.debug("Event [TIME RANDOM FADE] for toypad [{}] [{}] : [{}]", (Object)model.getToyPadNumber(), (Object)model.getPad().toString(), (Object)newValue);
                CommandToyPadEvent event = new CommandToyPadEvent(model, CommandEnum.RANDOM_FADE);
                PadPane.this.fireEvent(event);
            }
        });
        ListView tagList = new ListView();
        tagList.setItems(padModel.getTagsList());
        tagList.setPrefHeight(80.0);
        tagList.setCellFactory((Callback)new Callback<ListView<Tag>, ListCell<Tag>>(){

            public ListCell<Tag> call(ListView<Tag> param) {
                ListCell<Tag> cell = new ListCell<Tag>(){

                    protected void updateItem(Tag item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty || item == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else if (item.getName() != null) {
                            this.setText(item.getName());
                        } else {
                            this.setText("Unknown");
                        }
                    }
                };
                return cell;
            }
        });
        layout.getChildren().add((Object)tagList);
        this.setContent((Node)layout);
    }

    public void addCommandListeners(CommandListener listener) {
        this.commandListeners.add(CommandListener.class, listener);
    }

    private void fireEvent(CommandToyPadEvent event) {
        if (this.commandListeners != null) {
            for (CommandListener listener : (CommandListener[])this.commandListeners.getListeners(CommandListener.class)) {
                listener.newCommand(event);
            }
        }
    }
}

