/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.gui.view;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;

public class ToggleGroupValue<T>
extends ToggleGroup {
    private final ObjectProperty<T> valueObjectProperty = new SimpleObjectProperty<T>((Object)this, "value", null){

        public void set(T value) {
            super.set(value);
            if (value == null) {
                ToggleGroupValue.this.selectToggle(null);
                return;
            }
            for (Toggle lToggle : ToggleGroupValue.this.getToggles()) {
                if (lToggle.getUserData() == null || !lToggle.getUserData().equals(value) || ToggleGroupValue.this.getSelectedToggle() == lToggle) continue;
                ToggleGroupValue.this.selectToggle(lToggle);
                return;
            }
        }
    };

    public ToggleGroupValue() {
        this.construct();
    }

    private void construct() {
        this.selectedToggleProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable toggleProperty) {
                Toggle lToggle = (Toggle)ToggleGroupValue.this.selectedToggleProperty().get();
                if (lToggle == null) {
                    ToggleGroupValue.this.valueObjectProperty.set(null);
                } else {
                    Object lValue = lToggle.getUserData();
                    ToggleGroupValue.this.valueObjectProperty.set(lValue);
                }
            }
        });
    }

    public void add(Toggle toggle, T value) {
        toggle.setToggleGroup((ToggleGroup)this);
        toggle.setUserData(value);
    }

    public ObjectProperty<T> valueProperty() {
        return this.valueObjectProperty;
    }

    public T getValue() {
        return (T)this.valueObjectProperty.getValue();
    }

    public void setValue(T value) {
        this.valueObjectProperty.setValue(value);
    }

    public ToggleGroupValue<T> withValue(T value) {
        this.setValue(value);
        return this;
    }
}

