/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.gui.view;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.dajlab.core.CommandListener;
import org.dajlab.gui.AbstractDajlabTab;
import org.dajlab.jtoypad.gui.model.ToyPadModel;
import org.dajlab.jtoypad.gui.view.PadPane;

public class ToyPadTab
extends AbstractDajlabTab {
    private ToyPadModel model;

    public ToyPadTab(ToyPadModel toyPadModel, CommandListener listener) {
        this.model = toyPadModel;
        this.textProperty().bind((ObservableValue)this.model.titleProperty());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.model.usbIdProperty());
        this.setTooltip(tooltip);
        this.setClosable(false);
        this.enableRenaming("/toypad32.png");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        PadPane paneL = new PadPane(this.model.getLeftPadModel());
        paneL.addCommandListeners(listener);
        grid.add((Node)paneL, 0, 0);
        PadPane paneC = new PadPane(this.model.getCenterPadModel());
        paneC.addCommandListeners(listener);
        grid.add((Node)paneC, 1, 0);
        PadPane paneR = new PadPane(this.model.getRightPadModel());
        paneR.addCommandListeners(listener);
        grid.add((Node)paneR, 2, 0);
        PadPane paneA = new PadPane(this.model.getAllPadModel());
        paneA.addCommandListeners(listener);
        grid.add((Node)paneA, 3, 0);
        this.setContent((Node)grid);
    }

    @Override
    public void updateTitle(String title) {
        this.model.setTitle(title);
    }
}

