/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.adapters.extras;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class FontTypeAdapter
extends TypeAdapter<Font> {
    public void write(JsonWriter out, Font value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        String family = value.getFamily();
        String style = value.getStyle();
        double size = value.getSize();
        out.value(family + "," + style + "," + size);
    }

    public Font read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String value = in.nextString();
        String path = in.getPath();
        String[] components = FontTypeAdapter.splitComponents(value, path);
        String family = components[0];
        String style = components[1];
        String sizeStr = components[2];
        FontWeight weight = FontTypeAdapter.extractWeight(style);
        FontPosture posture = FontTypeAdapter.extractPosture(style);
        double size = FontTypeAdapter.extractSize(sizeStr, path);
        return Font.font((String)family, (FontWeight)weight, (FontPosture)posture, (double)size);
    }

    private static String[] splitComponents(String value, String path) {
        String[] font = value.split(",");
        if (font.length < 3) {
            throw InvalidFontException.missingComponent(value, path);
        }
        return font;
    }

    private static FontWeight extractWeight(String style) {
        for (String styleWord : style.split("\\s")) {
            FontWeight weight = FontWeight.findByName((String)styleWord);
            if (weight == null || weight == FontWeight.NORMAL) continue;
            return weight;
        }
        return FontWeight.NORMAL;
    }

    private static FontPosture extractPosture(String style) {
        for (String styleWord : style.split("\\s")) {
            FontPosture posture = FontPosture.findByName((String)styleWord);
            if (posture == null || posture == FontPosture.REGULAR) continue;
            return posture;
        }
        return FontPosture.REGULAR;
    }

    private static double extractSize(String size, String path) {
        try {
            return Double.parseDouble(size);
        }
        catch (NumberFormatException e) {
            throw InvalidFontException.invalidSize(size, path, e);
        }
    }

    public static class InvalidFontException
    extends RuntimeException {
        InvalidFontException(String message) {
            super(message);
        }

        InvalidFontException(String message, Throwable cause) {
            super(message, cause);
        }

        static InvalidFontException missingComponent(String value, String path) {
            return new InvalidFontException("Missing component in the font at path " + path + ", got '" + value + "'");
        }

        static InvalidFontException invalidSize(String value, String path, Throwable cause) {
            return new InvalidFontException("Invalid size for the font at path " + path + ", got '" + value + "'", cause);
        }
    }
}

