/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import org.apache.commons.collections4.CollectionUtils;
import org.dajlab.core.CommandEvent;
import org.dajlab.core.CommandListener;
import org.dajlab.gui.AbstractDajlabTab;
import org.dajlab.gui.MessageTab;
import org.dajlab.gui.MessagesUtil;
import org.dajlab.gui.extension.DajlabControllerExtensionInterface;
import org.dajlab.gui.extension.TabExtensionInterface;
import org.dajlab.jtoypad.core.FadeColor;
import org.dajlab.jtoypad.core.FlashColor;
import org.dajlab.jtoypad.core.JToypadConstants;
import org.dajlab.jtoypad.core.PadEnum;
import org.dajlab.jtoypad.core.TagEvent;
import org.dajlab.jtoypad.core.TagListener;
import org.dajlab.jtoypad.core.ToyPad;
import org.dajlab.jtoypad.core.ToyPadException;
import org.dajlab.jtoypad.core.ToyPadManager;
import org.dajlab.jtoypad.gui.model.CommandEnum;
import org.dajlab.jtoypad.gui.model.JToyPadModel;
import org.dajlab.jtoypad.gui.model.PadModel;
import org.dajlab.jtoypad.gui.model.ToyPadModel;
import org.dajlab.jtoypad.gui.view.CommandToyPadEvent;
import org.dajlab.jtoypad.gui.view.ToyPadTab;

public class JToyPadController
implements DajlabControllerExtensionInterface<JToyPadModel>,
TabExtensionInterface,
CommandListener,
TagListener {
    private ToyPadManager toyPadManager;
    private Map<String, ToyPad> toyPadsMap;
    private JToyPadModel mainModel = new JToyPadModel();
    private List<AbstractDajlabTab> tabs;
    private static final String MESSAGES_PREFIX = "jtoypad";
    private String errorCode = null;

    public JToyPadController() {
        this.toyPadManager = new ToyPadManager();
    }

    @Override
    public void connect() {
        try {
            this.toyPadManager.connect();
        }
        catch (ToyPadException e) {
            this.errorCode = e.getMessage();
        }
        List<ToyPad> toyPads = this.toyPadManager.getToyPads();
        this.toyPadsMap = new HashMap<String, ToyPad>(toyPads.size());
        int i = 0;
        for (ToyPad toyPad : toyPads) {
            this.toyPadsMap.put(toyPad.getIdentifiant(), toyPad);
            String title = "Toypad " + i;
            ToyPadModel tpm = new ToyPadModel(i, title, toyPad.getIdentifiant());
            this.mainModel.getToypads().put(Integer.toString(i), tpm);
            toyPad.addTagListener(this);
            ++i;
        }
    }

    @Override
    public void disconnect() {
        if (CollectionUtils.isNotEmpty(this.toyPadsMap.values())) {
            for (ToyPad toyPad : this.toyPadsMap.values()) {
                try {
                    toyPad.turnOffPads();
                }
                catch (ToyPadException toyPadException) {}
            }
        }
        this.toyPadManager.disconnect();
    }

    public List<AbstractDajlabTab> getTabs() {
        if (this.tabs == null) {
            if (CollectionUtils.isNotEmpty(this.mainModel.getToypads().values())) {
                this.tabs = new ArrayList<AbstractDajlabTab>(this.mainModel.getToypads().size());
                for (ToyPadModel toyPadModel : this.mainModel.getToypads().values()) {
                    ToyPadTab tab = new ToyPadTab(toyPadModel, this);
                    this.tabs.add(tab);
                }
            } else {
                this.tabs = new ArrayList<AbstractDajlabTab>(1);
                MessageTab messTab = null;
                messTab = this.errorCode != null ? new MessageTab(MessagesUtil.getString(JToypadConstants.ERR_NO_DEVICES), MessagesUtil.getString(this.errorCode), new String[0]) : new MessageTab("JToypad", JToypadConstants.ICON_JTOYPAD, MessagesUtil.getString(JToypadConstants.ERR_NO_DEVICES));
                this.tabs.add(messTab);
            }
        }
        return this.tabs;
    }

    @Override
    public void newCommand(final CommandEvent ev) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ev instanceof CommandToyPadEvent) {
                    CommandToyPadEvent event = (CommandToyPadEvent)ev;
                    String toyPadModelNumber = Integer.toString(event.getPadModel().getToyPadNumber());
                    String usbId = JToyPadController.this.mainModel.getToypads().get(toyPadModelNumber).getUsbId();
                    ToyPad toyPad = (ToyPad)JToyPadController.this.toyPadsMap.get(usbId);
                    PadModel padModel = event.getPadModel();
                    if (event.getCommand() == null || padModel.getActiveCommand() == event.getCommand()) {
                        PadEnum pad = padModel.getPad();
                        try {
                            CommandEnum command = padModel.getActiveCommand();
                            switch (command) {
                                case OFF: {
                                    toyPad.switchPad(pad, org.dajlab.jtoypad.core.Color.BLACK);
                                    break;
                                }
                                case ON: {
                                    toyPad.switchPad(pad, JToyPadController.convertColor(padModel.getColorOn()));
                                    break;
                                }
                                case FLASH: {
                                    toyPad.flashPad(pad, new FlashColor(JToyPadController.convertColor(padModel.getColorFlashOn()), padModel.getTimeFlashOn(), JToyPadController.convertColor(padModel.getColorFlashOff()), padModel.getTimeFlashOff(), 255));
                                    break;
                                }
                                case FADE: {
                                    toyPad.fadePad(pad, new FadeColor(JToyPadController.convertColor(padModel.getColor1Fade()), JToyPadController.convertColor(padModel.getColor2Fade()), padModel.getTimeFade(), 255));
                                    break;
                                }
                                case RANDOM_FADE: {
                                    toyPad.fadePadRandom(pad, padModel.getTimeRandomFade(), 255);
                                    break;
                                }
                                default: {
                                    toyPad.switchPad(pad, org.dajlab.jtoypad.core.Color.BLACK);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void updateModel(final JToyPadModel model) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (model != null) {
                    Set connectedUsbAdresses = JToyPadController.this.toyPadsMap.keySet();
                    HashSet<String> loadedUsbAdresses = new HashSet<String>();
                    for (ToyPadModel tpm : model.getToypads().values()) {
                        loadedUsbAdresses.add(tpm.getUsbId());
                    }
                    if (CollectionUtils.isEqualCollection(connectedUsbAdresses, loadedUsbAdresses)) {
                        for (String idtpmodel : model.getToypads().keySet()) {
                            ToyPadModel modelToUpdate = JToyPadController.this.mainModel.getToypads().get(idtpmodel);
                            ToyPadModel newModel = model.getToypads().get(idtpmodel);
                            JToyPadController.this.updateToyPadModel(modelToUpdate, newModel);
                        }
                    }
                }
            }
        });
    }

    private void updateToyPadModel(ToyPadModel currentModel, ToyPadModel newModel) {
        currentModel.setTitle(newModel.getTitle());
        for (PadEnum pad : PadEnum.values()) {
            currentModel.getPadModel(pad).setColorOn(newModel.getPadModel(pad).getColorOn());
            currentModel.getPadModel(pad).setColor1Fade(newModel.getPadModel(pad).getColor1Fade());
            currentModel.getPadModel(pad).setColor2Fade(newModel.getPadModel(pad).getColor2Fade());
            currentModel.getPadModel(pad).setTimeFade(newModel.getPadModel(pad).getTimeFade());
            currentModel.getPadModel(pad).setColorFlashOn(newModel.getPadModel(pad).getColorFlashOn());
            currentModel.getPadModel(pad).setColorFlashOff(newModel.getPadModel(pad).getColorFlashOff());
            currentModel.getPadModel(pad).setTimeFlashOn(newModel.getPadModel(pad).getTimeFlashOn());
            currentModel.getPadModel(pad).setTimeFlashOff(newModel.getPadModel(pad).getTimeFlashOff());
            currentModel.getPadModel(pad).setTimeRandomFade(newModel.getPadModel(pad).getTimeRandomFade());
            currentModel.getPadModel(pad).setActiveCommand(newModel.getPadModel(pad).getActiveCommand());
        }
    }

    @Override
    public JToyPadModel getModel() {
        return this.mainModel;
    }

    public static org.dajlab.jtoypad.core.Color convertColor(Color color) {
        org.dajlab.jtoypad.core.Color col = new org.dajlab.jtoypad.core.Color((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
        return col;
    }

    @Override
    public void newTagEvent(final TagEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ToyPad tp = event.getSource();
                String idToyPadModel = null;
                for (ToyPadModel tpm : JToyPadController.this.mainModel.getToypads().values()) {
                    if (!tpm.getUsbId().equals(tp.getIdentifiant())) continue;
                    idToyPadModel = Integer.toString(tpm.getNumber());
                }
                PadModel padModel = JToyPadController.this.mainModel.getToypads().get(idToyPadModel).getPadModel(event.getPad());
                switch (event.getAction()) {
                    case ADDED: {
                        padModel.getTagsList().add((Object)event.getTag());
                        break;
                    }
                    case REMOVED: {
                        padModel.getTagsList().remove((Object)event.getTag());
                        break;
                    }
                }
            }
        });
    }

    @Override
    public String getLocalization() {
        return MESSAGES_PREFIX;
    }

    public final Map<String, ToyPad> getToyPadsMap() {
        return this.toyPadsMap;
    }
}

