/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jtoypad.gui.view;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;

public class TimeSpinner
extends Spinner<Integer> {
    private final IntegerProperty valueObjectProperty = new SimpleIntegerProperty((Object)this, "time", 0);

    public TimeSpinner() {
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, Integer.MAX_VALUE, 10, 1);
        this.setValueFactory((SpinnerValueFactory)valueFactory);
        this.setPrefSize(80.0, 25.0);
        this.getStyleClass().add((Object)"split-arrows-horizontal");
        this.setEditable(true);
        this.getValueFactory().valueProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable obs) {
                Integer tin = (Integer)TimeSpinner.this.getValueFactory().valueProperty().get();
                if (tin == null) {
                    TimeSpinner.this.valueObjectProperty.set(10);
                } else {
                    TimeSpinner.this.valueObjectProperty.set(tin.intValue());
                }
            }
        });
        this.valueObjectProperty.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                TimeSpinner.this.getValueFactory().valueProperty().setValue((Object)TimeSpinner.this.valueObjectProperty.get());
            }
        });
        this.getEditor().setOnAction(action -> {
            StringConverter converter;
            String text = this.getEditor().getText();
            if (StringUtils.isNumeric((CharSequence)text) && this.getValueFactory() != null && (converter = this.getValueFactory().getConverter()) != null) {
                Integer value = (Integer)converter.fromString(text);
                this.getValueFactory().setValue((Object)value);
            }
        });
    }

    public void increment(int steps) {
        SpinnerValueFactory valueFactory = this.getValueFactory();
        if (valueFactory == null) {
            throw new IllegalStateException("Can't increment Spinner with a null SpinnerValueFactory");
        }
        this.commitEditorText();
        valueFactory.increment(steps);
    }

    public void decrement(int steps) {
        SpinnerValueFactory valueFactory = this.getValueFactory();
        if (valueFactory == null) {
            throw new IllegalStateException("Can't decrement Spinner with a null SpinnerValueFactory");
        }
        this.commitEditorText();
        valueFactory.decrement(steps);
    }

    private void commitEditorText() {
        StringConverter converter;
        SpinnerValueFactory valueFactory;
        if (!this.isEditable()) {
            return;
        }
        String text = this.getEditor().getText();
        if (StringUtils.isNumeric((CharSequence)text) && (valueFactory = this.getValueFactory()) != null && (converter = valueFactory.getConverter()) != null) {
            Integer value = (Integer)converter.fromString(text);
            valueFactory.setValue((Object)value);
        }
    }

    public IntegerProperty timeProperty() {
        return this.valueObjectProperty;
    }

    public Integer getTime() {
        return this.valueObjectProperty.getValue();
    }

    public void setTime(Integer value) {
        this.valueObjectProperty.set(value.intValue());
    }
}

